using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI.controls;
using RACK = gov.va.med.vbecs.Common.VbecsTables.Rack;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmRecordLotNumbers
	/// </summary>
	public class FrmRecordLotNumbers : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Data.DataSet dataSet1;
		private System.Data.DataTable dataTable1;
		private System.Data.DataColumn dataColumn1;
		private System.Data.DataColumn dataColumn2;
		private System.Data.DataColumn dataColumn3;
		private System.Windows.Forms.TabControl tabLotNumbers;
		private System.Windows.Forms.TabPage[] pageRacks;
		private System.Data.DataColumn dataColumn4;
		private System.Windows.Forms.Panel pnlGrid;
		private controls.VbecsDataGrid dgRack;
		private System.Windows.Forms.DataGridTableStyle dataGridTableStyle1;
		private DataGridColoredTextBoxColumn dataGridTextBoxColumn;
		private controls.DataGridKeyTrapTextBoxColumn dataGridKeyTrapTextBoxColumn;
		private controls.ComboBoxLookup cmbBox;
		private controls.ComboBoxLookup cmbBoxTestingMethod;
		private System.ComponentModel.IContainer components = null;
		private DataTable[] _dtLotNumbers;
		private DataTable[] _dtRetestLotNumbers;
		private DataTable[] _dtPreviousTestLotNumbers;
		private DataTable _dtRacks;
		private DataTable _dtReagents;
		private System.Windows.Forms.GroupBox grpKey;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private int _nActiveRack;
		private System.Windows.Forms.CheckBox cbRackNotInUse;
		private bool _proceedWithLoad = true;
		private DateTime _currentDateTime;
		private DateTime _testDateTime;
		private DataTable _dtDailyQCReagentTypes;
		private bool _skipRackNotInUseCheckedChangedEvent = false;
		private bool _skipQCOfflineCheckedChangedEvent = false;
		private System.Windows.Forms.CheckBox cbQCOffline;
		private DataTable _dtRemovedLotNumbers;
        //CR 3298
	    private string _testingTech;
        //CR 1911
        private bool _isLoading;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="dtRacks"></param>
		/// <param name="testDateTime"></param>
        /// <param name="testingTech"></param>
        public FrmRecordLotNumbers(DataTable dtRacks, DateTime testDateTime, string testingTech)
		{
            //CR 1911
            _isLoading = true;

			this.LockController.LockFunction = Common.LockFunctions.UC028EnterReagentQCResults;

			// This call is required by the Windows Form Designer.
			_currentDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			_testDateTime = testDateTime;
			InitializeComponent();

			//-----------------------------------------------------------
			foreach (System.Data.DataRow dr in dtRacks.Rows)
			{
				this.LockController.RecordGuids.Add((System.Guid)dr[RACK.RackGuid]);
			}
			//-----------------------------------------------------------

			//Setting form level variable _proceedWithLoad for DlgSelectRack.btnOK_Click() to capture
			this._proceedWithLoad = this.SetLocks();

			if (!this._proceedWithLoad)
				return;

			InitializeCustomComponents(dtRacks);
			SetComponentProperties();
			LoadRackRetestData();
			LoadRackDataFromPreviousTest();
			LoadDailyQCReagentTypes();

			_dtRemovedLotNumbers = new DataTable();
			_dtRemovedLotNumbers.Columns.Add("Lot_Number");
			_dtRemovedLotNumbers.Columns.Add("Manufacturer");
			_dtRemovedLotNumbers.CaseSensitive = true;
            //CR 3298
		    this._testingTech = testingTech;
		}

		/// <summary>
		/// Get/Set DTLotNumbers
		/// </summary>
		public DataTable[] DTLotNumbers
		{
			get
			{
				return this._dtLotNumbers;
			}
			set
			{
				this._dtLotNumbers = value;
			}
		}

		/// <summary>
		/// Get ProceedWithLoad
		/// </summary>
		public bool ProceedWithLoad
		{
			get
			{
				return this._proceedWithLoad;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				//Cleanup -- and for locking
				((FrmDailyReagentRackQC)this.Tag).Dispose();        //TODO: WTF is this?

				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmRecordLotNumbers));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.cbRackNotInUse = new System.Windows.Forms.CheckBox();
			this.dgRack = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.dataGridTableStyle1 = new System.Windows.Forms.DataGridTableStyle();
			this.cmbBox = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.cmbBoxTestingMethod = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dataTable1 = new System.Data.DataTable();
			this.dataColumn1 = new System.Data.DataColumn();
			this.dataColumn2 = new System.Data.DataColumn();
			this.dataColumn3 = new System.Data.DataColumn();
			this.dataColumn4 = new System.Data.DataColumn();
			this.dataSet1 = new System.Data.DataSet();
			this.tabLotNumbers = new System.Windows.Forms.TabControl();
			this.pnlGrid = new System.Windows.Forms.Panel();
			this.cbQCOffline = new System.Windows.Forms.CheckBox();
			this.grpKey = new System.Windows.Forms.GroupBox();
			this.label6 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dgRack)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).BeginInit();
			this.pnlGrid.SuspendLayout();
			this.grpKey.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			this.vbecsLogo1.Title = "Reagent QC - Record Lot Numbers";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 507);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(40, 458);
			this.grpImage.TabIndex = 11;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(32, 36);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(662, 496);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(582, 496);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// cbRackNotInUse
			// 
			this.cbRackNotInUse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cbRackNotInUse.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.cbRackNotInUse.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbRackNotInUse.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cbRackNotInUse.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.cbRackNotInUse.Location = new System.Drawing.Point(534, 4);
			this.cbRackNotInUse.Name = "cbRackNotInUse";
			this.cbRackNotInUse.Size = new System.Drawing.Size(144, 18);
			this.cbRackNotInUse.TabIndex = 0;
			this.cbRackNotInUse.Text = "&Rack not in use today";
			this.cbRackNotInUse.CheckedChanged += new System.EventHandler(this.cbRackNotInUse_CheckedChanged);
			// 
			// dgRack
			// 
			this.dgRack.AllowSorting = false;
			this.dgRack.AlternatingBackColor = System.Drawing.SystemColors.ControlLightLight;
			this.dgRack.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgRack.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgRack.CaptionText = "Record Lot Numbers for Daily QC Testing";
			this.dgRack.CaptionVisible = false;
			this.dgRack.DataMember = "";
			this.dgRack.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgRack.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgRack.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgRack.Location = new System.Drawing.Point(4, 3);
			this.dgRack.Name = "dgRack";
			this.dgRack.PreferredColumnWidth = 100;
			this.dgRack.PreferredRowHeight = 22;
			this.dgRack.RightMostColumn = 0;
			this.dgRack.RowHeadersVisible = false;
			this.dgRack.Size = new System.Drawing.Size(678, 347);
			this.dgRack.TabIndex = 1;
			this.dgRack.TableStyles.AddRange(new System.Windows.Forms.DataGridTableStyle[] {
																							   this.dataGridTableStyle1});
			this.dgRack.ToolTipColumn = -1;
			this.dgRack.CurrentCellChanged += new System.EventHandler(this.dgRack_CurrentCellChanged);
			// 
			// dataGridTableStyle1
			// 
			this.dataGridTableStyle1.AllowSorting = false;
			this.dataGridTableStyle1.DataGrid = this.dgRack;
			this.dataGridTableStyle1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGridTableStyle1.MappingName = "";
			this.dataGridTableStyle1.PreferredRowHeight = 22;
			this.dataGridTableStyle1.RowHeadersVisible = false;
			// 
			// cmbBox
			// 
			this.cmbBox.Interval = 500;
			this.cmbBox.Location = new System.Drawing.Point(0, 0);
			this.cmbBox.Name = "cmbBox";
			this.cmbBox.Size = new System.Drawing.Size(118, 19);
			this.cmbBox.TabIndex = 0;
			this.cmbBox.Leave += new System.EventHandler(this.cmbBox_Leave);
			// 
			// cmbBoxTestingMethod
			// 
			this.cmbBoxTestingMethod.Interval = 500;
			this.cmbBoxTestingMethod.Location = new System.Drawing.Point(0, 0);
			this.cmbBoxTestingMethod.Name = "cmbBoxTestingMethod";
			this.cmbBoxTestingMethod.Size = new System.Drawing.Size(78, 19);
			this.cmbBoxTestingMethod.TabIndex = 0;
			this.cmbBoxTestingMethod.Leave += new System.EventHandler(this.cmbBoxTestingMethod_Leave);
			// 
			// dataTable1
			// 
			this.dataTable1.Columns.AddRange(new System.Data.DataColumn[] {
																			  this.dataColumn1,
																			  this.dataColumn2,
																			  this.dataColumn3,
																			  this.dataColumn4});
			this.dataTable1.TableName = "Table1";
			// 
			// dataColumn1
			// 
			this.dataColumn1.ColumnName = "Reagent Type";
			this.dataColumn1.ReadOnly = true;
			// 
			// dataColumn2
			// 
			this.dataColumn2.ColumnName = "Lot Number*";
			// 
			// dataColumn3
			// 
			this.dataColumn3.Caption = "Manufacturer";
			this.dataColumn3.ColumnName = "Manufacturer";
			// 
			// dataColumn4
			// 
			this.dataColumn4.ColumnName = "Expiration Date";
			// 
			// dataSet1
			// 
			this.dataSet1.DataSetName = "NewDataSet";
			this.dataSet1.Locale = new System.Globalization.CultureInfo("en-US");
			this.dataSet1.Tables.AddRange(new System.Data.DataTable[] {
																		  this.dataTable1});
			// 
			// tabLotNumbers
			// 
			this.tabLotNumbers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabLotNumbers.Location = new System.Drawing.Point(44, 36);
			this.tabLotNumbers.Name = "tabLotNumbers";
			this.tabLotNumbers.SelectedIndex = 0;
			this.tabLotNumbers.Size = new System.Drawing.Size(694, 382);
			this.tabLotNumbers.TabIndex = 0;
			this.tabLotNumbers.SelectedIndexChanged += new System.EventHandler(this.tabLotNumbers_SelectedIndexChanged);
			// 
			// pnlGrid
			// 
			this.pnlGrid.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlGrid.Controls.Add(this.cbQCOffline);
			this.pnlGrid.Controls.Add(this.cbRackNotInUse);
			this.pnlGrid.Controls.Add(this.dgRack);
			this.pnlGrid.Location = new System.Drawing.Point(48, 60);
			this.pnlGrid.Name = "pnlGrid";
			this.pnlGrid.Size = new System.Drawing.Size(686, 354);
			this.pnlGrid.TabIndex = 1;
			// 
			// cbQCOffline
			// 
			this.cbQCOffline.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cbQCOffline.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.cbQCOffline.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbQCOffline.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cbQCOffline.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.cbQCOffline.Location = new System.Drawing.Point(304, 4);
			this.cbQCOffline.Name = "cbQCOffline";
			this.cbQCOffline.Size = new System.Drawing.Size(212, 18);
			this.cbQCOffline.TabIndex = 2;
			this.cbQCOffline.Text = "&QC Testing Documentation Offline";
			this.cbQCOffline.CheckedChanged += new System.EventHandler(this.cbQCOffline_CheckedChanged);
			// 
			// grpKey
			// 
			this.grpKey.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpKey.Controls.Add(this.label6);
			this.grpKey.Controls.Add(this.label5);
			this.grpKey.Controls.Add(this.label4);
			this.grpKey.Controls.Add(this.label3);
			this.grpKey.Controls.Add(this.label2);
			this.grpKey.Controls.Add(this.label1);
			this.grpKey.Location = new System.Drawing.Point(44, 418);
			this.grpKey.Name = "grpKey";
			this.grpKey.Size = new System.Drawing.Size(694, 72);
			this.grpKey.TabIndex = 2;
			this.grpKey.TabStop = false;
			this.grpKey.Text = "Key";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(36, 48);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(140, 16);
			this.label6.TabIndex = 5;
			this.label6.Text = "Expired Reagent";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label5
			// 
			this.label5.BackColor = System.Drawing.Color.Red;
			this.label5.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label5.Location = new System.Drawing.Point(8, 48);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(16, 16);
			this.label5.TabIndex = 4;
			this.label5.Text = "E";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(36, 32);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(184, 16);
			this.label4.TabIndex = 3;
			this.label4.Text = "Reagent will expire within 24 hours.";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(36, 16);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(100, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Valid Reagent";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.BackColor = System.Drawing.Color.Yellow;
			this.label2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label2.Location = new System.Drawing.Point(8, 32);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(16, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "W";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label1
			// 
			this.label1.BackColor = System.Drawing.Color.Lime;
			this.label1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label1.CausesValidation = false;
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(16, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "V";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// FrmRecordLotNumbers
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 523);
			this.Controls.Add(this.pnlGrid);
			this.Controls.Add(this.tabLotNumbers);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpKey);
			this.hlphelpChm.SetHelpKeyword(this, "Enter_Daily_QC_Results.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(750, 550);
			this.Name = "FrmRecordLotNumbers";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Enter Daily QC Results";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmRecordLotNumbers_Closing);
			this.SizeChanged += new System.EventHandler(this.FrmRecordLotNumbers_SizeChanged);
			this.Load += new System.EventHandler(this.FrmRecordLotNumbers_Load);
			this.Controls.SetChildIndex(this.grpKey, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.tabLotNumbers, 0);
			this.Controls.SetChildIndex(this.pnlGrid, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dgRack)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).EndInit();
			this.pnlGrid.ResumeLayout(false);
			this.grpKey.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Creates number of tabpages equal to the number of racks tested
		/// </summary>
		/// <param name="dtRacks"></param>
		private void InitializeCustomComponents(DataTable dtRacks)
		{
			int nNumberOfRacks = dtRacks.Rows.Count;
			// 
			// Expired
			// 
			this.dataGridTextBoxColumn = new gov.va.med.vbecs.GUI.DataGridColoredTextBoxColumn();
			this.dataGridTextBoxColumn.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.dataGridTextBoxColumn.Format = "";
			this.dataGridTextBoxColumn.FormatInfo = null;
			this.dataGridTextBoxColumn.HeaderText = "";
			this.dataGridTextBoxColumn.MappingName = "Expired";
			this.dataGridTextBoxColumn.Width = 20;
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridTextBoxColumn);
			// 
			// ReagentTypeId
			// 
			this.dataGridTextBoxColumn = new gov.va.med.vbecs.GUI.DataGridColoredTextBoxColumn();
			this.dataGridTextBoxColumn.Format = "";
			this.dataGridTextBoxColumn.FormatInfo = null;
			this.dataGridTextBoxColumn.HeaderText = "ReagentTypeId";
			this.dataGridTextBoxColumn.MappingName = "ReagentTypeId";
			this.dataGridTextBoxColumn.Width = 0;
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridTextBoxColumn);
			// 
			// ReagentType
			// 
			this.dataGridTextBoxColumn = new gov.va.med.vbecs.GUI.DataGridColoredTextBoxColumn();
			this.dataGridTextBoxColumn.Format = "";
			this.dataGridTextBoxColumn.FormatInfo = null;
			this.dataGridTextBoxColumn.HeaderText = "Reagent Type";
			this.dataGridTextBoxColumn.MappingName = "ReagentType";
			this.dataGridTextBoxColumn.Width = 150;
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridTextBoxColumn);
			// 
			// LotNumber
			// 
			this.dataGridKeyTrapTextBoxColumn = new gov.va.med.vbecs.GUI.controls.DataGridKeyTrapTextBoxColumn();
			this.dataGridKeyTrapTextBoxColumn.Format = "";
			this.dataGridKeyTrapTextBoxColumn.FormatInfo = null;
			this.dataGridKeyTrapTextBoxColumn.HeaderText = "Lot Number*";
			this.dataGridKeyTrapTextBoxColumn.MappingName = "Lot_Number";
			this.dataGridKeyTrapTextBoxColumn.Width = 120;
			this.dataGridKeyTrapTextBoxColumn.ProcessAcross = false;
			this.dataGridKeyTrapTextBoxColumn.TextBox.Controls.Add(cmbBox);
			cmbBox.BringToFront();
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridKeyTrapTextBoxColumn);
			// 
			// Manufacturer
			// 
			this.dataGridTextBoxColumn = new gov.va.med.vbecs.GUI.DataGridColoredTextBoxColumn();
			this.dataGridTextBoxColumn.Format = "";
			this.dataGridTextBoxColumn.FormatInfo = null;
			this.dataGridTextBoxColumn.HeaderText = "Manufacturer";
			this.dataGridTextBoxColumn.MappingName = "Manufacturer";
			this.dataGridTextBoxColumn.Width = 210;
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridTextBoxColumn);
			// 
			// ExpirationDate
			// 
			this.dataGridTextBoxColumn = new gov.va.med.vbecs.GUI.DataGridColoredTextBoxColumn();
			this.dataGridTextBoxColumn.Format = "";
			this.dataGridTextBoxColumn.FormatInfo = null;
			this.dataGridTextBoxColumn.HeaderText = "Expiration Date";
			this.dataGridTextBoxColumn.MappingName = "Expiration Date";
			this.dataGridTextBoxColumn.Width = 100;
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridTextBoxColumn);
			// 
			// TestMethod
			// 
			this.dataGridKeyTrapTextBoxColumn = new gov.va.med.vbecs.GUI.controls.DataGridKeyTrapTextBoxColumn();
			this.dataGridKeyTrapTextBoxColumn.Format = "";
			this.dataGridKeyTrapTextBoxColumn.FormatInfo = null;
			this.dataGridKeyTrapTextBoxColumn.HeaderText = "Test Method*";
			this.dataGridKeyTrapTextBoxColumn.MappingName = Common.VbecsTables.TestingMethod.TestingMethodText;
			this.dataGridKeyTrapTextBoxColumn.Width = 80;
			this.dataGridKeyTrapTextBoxColumn.ProcessAcross = false;
			this.dataGridTableStyle1.GridColumnStyles.Add(this.dataGridKeyTrapTextBoxColumn);
			this.dataGridKeyTrapTextBoxColumn.TextBox.Controls.Add(cmbBoxTestingMethod);
			// 

			this.pageRacks = new System.Windows.Forms.TabPage[nNumberOfRacks];

			for (int i=0 ; i<nNumberOfRacks ; i++)
			{
				this.pageRacks[i] = new System.Windows.Forms.TabPage(dtRacks.Rows[i][Common.VbecsTables.Rack.RackName].ToString());
				this.pageRacks[i].Tag = i;
				this.pageRacks[i].Location = new System.Drawing.Point(4, 23);
				this.pageRacks[i].Size = new System.Drawing.Size(488, 375);
				this.pageRacks[i].TabIndex = i;
			}

			this.tabLotNumbers.Controls.AddRange(this.pageRacks);
			_dtRacks = dtRacks;

			this.cmbBoxTestingMethod.Items.Add(Common.TestingMethod.Tube.ToString());
			this.cmbBoxTestingMethod.Items.Add(Common.TestingMethod.Gel.ToString());
			this.cmbBoxTestingMethod.Items.Add(Common.TestingMethod.Solid.ToString());
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Enter Daily QC Results";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC028.FrmRecordLotNumbers());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
			dgRack.ReadOnly = true;
			this.dgRack.NextCell += new controls.NextCellEventHandler(SetNextCell);
			dgRack.ToolTipColumn = -1;
			cmbBox.LookupEnabled = true;
			this.cmbBoxTestingMethod.LookupEnabled = true;
			this.dgRack.CaptionVisible = true;
			this.dgRack.LostFocus += new EventHandler(dgRack_LostFocus);
		}

		/// <summary>
		/// Load lot numbers for retested racks
		/// </summary>
		private void LoadRackRetestData()
		{
			int nNumberOfRacks = _dtRacks.Rows.Count;
			int nCounter = 0;

			_dtRetestLotNumbers = new DataTable[nNumberOfRacks];

			try
			{
				foreach(DataRow drRack in this._dtRacks.Rows)
				{
					_dtRetestLotNumbers[nCounter] = BOL.Reagent.GetReagentLotsForRetest((Guid)drRack[Common.VbecsTables.Rack.RackGuid]);
					nCounter++;
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
			}

		}

		/// <summary>
		/// Load lot numbers from previous test
		/// </summary>
		private void LoadRackDataFromPreviousTest()
		{
			int nNumberOfRacks = _dtRacks.Rows.Count;
			int nCounter = 0;

			_dtPreviousTestLotNumbers = new DataTable[nNumberOfRacks];

			try
			{
				foreach(DataRow drRack in this._dtRacks.Rows)
				{
					_dtPreviousTestLotNumbers[nCounter] = BOL.Reagent.GetReagentLotsFromPreviousTest(drRack[Common.VbecsTables.Rack.RackName].ToString());
					nCounter++;
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
			}

		}

		private void LoadDailyQCReagentTypes()
		{
			int nNumberOfRacks = _dtRacks.Rows.Count;
			int nNumberOfLots;
			DataTable dtReagentTypes;
			DataTable dtEnhancementMedia = new DataTable();
			DataRow[] drReagentType;
			DataRow[] drTestWithLotNumber;
			DataRow[] drEnhancementMedia;
			Guid dailyQcWorklistGuid = Guid.Empty;
			bool partiallyTestedIndicator = false;

			for(int i=0 ; i<nNumberOfRacks ; i++)
			{
				if (this._dtRacks.Rows[i].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == false)
				{
					dailyQcWorklistGuid = (Guid)this._dtRacks.Rows[i][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid];
					partiallyTestedIndicator = (bool)this._dtRacks.Rows[i][Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator];
					break;
				}
			}

			try
			{
				if (dailyQcWorklistGuid != Guid.Empty &&
					partiallyTestedIndicator == true)
				{
					_dtDailyQCReagentTypes = BOL.ReagentType.GetDailyQCReagentTypesForPartiallyCompletedQc(dailyQcWorklistGuid);
				}
				else
				{
					_dtDailyQCReagentTypes = BOL.ReagentType.GetDailyQCReagentTypes(LogonUser.LogonUserDivisionCode);
					dtEnhancementMedia = (new BOL.EnhancementMedia()).GetEnhancementMediaDataTable();
				}
				dtReagentTypes = BOL.ReagentType.GetReagentTypes();
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				_dtDailyQCReagentTypes = new DataTable();
				dtReagentTypes = new DataTable();
				dtEnhancementMedia = new DataTable();
			}

			_dtLotNumbers = new DataTable[nNumberOfRacks];

			for(int i=0 ; i<nNumberOfRacks ; i++)
			{
				_dtLotNumbers[i] = new DataTable();
				_dtLotNumbers[i].Columns.Add("Expired");
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.ReagentType.ReagentTypeId);
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.Reagent.ReagentGuid, typeof(System.Guid));
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.RackLot.TestWithName);
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.RackLot.TestWithId, typeof(int));
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.RackLot.ExpectedMinimumReactions);
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.ReactivityPhase.ReactivityPhaseText);
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode);
				_dtLotNumbers[i].Columns.Add("ReagentType");
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.ReagentTestParameter.SetVialId);
				_dtLotNumbers[i].Columns.Add("Lot_Number");
				_dtLotNumbers[i].Columns.Add("Manufacturer");
				_dtLotNumbers[i].Columns.Add("Expiration Date");
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.TestingMethod.TestingMethodText);
				_dtLotNumbers[i].Columns.Add("OverrideComment");
				_dtLotNumbers[i].Columns.Add(Common.VbecsTables.Reagent.InspectionIndicator, typeof(bool));
				_dtLotNumbers[i].Columns.Add("TestWithReagent", typeof(bool));
				_dtLotNumbers[i].Columns.Add("ReagentTypeForQCTemplate");
				_dtLotNumbers[i].Columns.Add("ReagentTypeIDForQCTemplate", typeof(int));
				_dtLotNumbers[i].Columns.Add("ReagentExpiredException", typeof(BOL.ExceptionReport));
				_dtLotNumbers[i].Columns.Add("Insert", typeof(bool));

				int lastTestableReagent = 0;

				foreach(DataRow drDailyQCReagentType in _dtDailyQCReagentTypes.Rows)
				{
					DataRow drLotNumber = _dtLotNumbers[i].NewRow();

					if (this._dtLotNumbers[i].Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeId].ToString() + "' AND " + Common.VbecsTables.RackLot.TestWithId + " = '" + drDailyQCReagentType[Common.VbecsTables.RackLot.TestWithId].ToString() + "' AND " + Common.VbecsTables.RackLot.TestWithName + " = '" + drDailyQCReagentType[Common.VbecsTables.RackLot.TestWithName].ToString() + "' AND SetVialId = '" + drDailyQCReagentType["SetVialId"].ToString() + "' AND ReactivityPhaseCode = '" + drDailyQCReagentType[Common.VbecsTables.RackLot.ReactivityPhaseCode].ToString() + "'").Length > 0)
						continue;

					//for A1 and B Cells show "Reverse ABO Typing Cells" on LotNumber screen and use reagent type id = 62 for determining applicable lot numbers
					if (drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("A1 Cell") != -1 ||
						drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("B Cell") != -1)
					{
						drLotNumber["ReagentType"] = "Reverse ABO Typing Cells";
						drLotNumber["ReagentTypeForQCTemplate"] = drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName];
						drLotNumber["ReagentTypeIDForQCTemplate"] = drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeId];
						drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = 62;
						if (drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("A1 Cell") != -1)
							drLotNumber[Common.VbecsTables.ReagentTestParameter.SetVialId] = "1";
						else
							drLotNumber[Common.VbecsTables.ReagentTestParameter.SetVialId] = "2";
					}
					else if (drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("Reverse ABO Typing Cells") != -1)
					{
						if (drDailyQCReagentType[Common.VbecsTables.ReagentTestParameter.SetVialId].ToString().Trim() == "1")
						{
							drLotNumber["ReagentTypeForQCTemplate"] = "A1 Cell";
							drLotNumber["ReagentTypeIDForQCTemplate"] = 1;
							drLotNumber["SetVialId"] = "1";
						}
						else
						{
							drLotNumber["ReagentTypeForQCTemplate"] = "B Cell";
							drLotNumber["ReagentTypeIDForQCTemplate"] = 3;
							drLotNumber["SetVialId"] = "2";
						}

						drLotNumber["ReagentType"] = "Reverse ABO Typing Cells";
						drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = 62;
					}
					else
					{
						drLotNumber["ReagentType"] = drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName];
						drLotNumber["ReagentTypeForQCTemplate"] = drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeName];
						drLotNumber["ReagentTypeIDForQCTemplate"] = drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeId];
						drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = drDailyQCReagentType[Common.VbecsTables.ReagentType.ReagentTypeId];
						drLotNumber[Common.VbecsTables.ReagentTestParameter.SetVialId] = drDailyQCReagentType[Common.VbecsTables.ReagentTestParameter.SetVialId];
					}

					drLotNumber[Common.VbecsTables.RackLot.TestWithId] = drDailyQCReagentType[Common.VbecsTables.RackLot.TestWithId];
					drLotNumber[Common.VbecsTables.RackLot.TestWithName] = drDailyQCReagentType[Common.VbecsTables.RackLot.TestWithName];
					drLotNumber[Common.VbecsTables.RackLot.ExpectedMinimumReactions] = drDailyQCReagentType[Common.VbecsTables.RackLot.ExpectedMinimumReactions];
					drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText] = drDailyQCReagentType[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText];
					drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode] = drDailyQCReagentType[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode];

					drLotNumber["OverrideComment"] = string.Empty;

					if (dailyQcWorklistGuid != Guid.Empty &&
						partiallyTestedIndicator == true)
					{
						drLotNumber["Expired"] = GetExpiredColumnValue((DateTime)drDailyQCReagentType[Common.VbecsTables.Reagent.LotExpirationDate]);
						drLotNumber[Common.VbecsTables.Reagent.ReagentGuid] = drDailyQCReagentType[Common.VbecsTables.Reagent.ReagentGuid];
						drLotNumber["Lot_Number"] = drDailyQCReagentType[Common.VbecsTables.Reagent.LotNumber];
						drLotNumber["Manufacturer"] = drDailyQCReagentType[Common.VbecsTables.Reagent.ReagentManufacturerName];
						drLotNumber["Expiration Date"] = drDailyQCReagentType[Common.VbecsTables.Reagent.LotExpirationDate].ToString();
						drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText] = drDailyQCReagentType[Common.VbecsTables.TestingMethod.TestingMethodText].ToString();
						if (drLotNumber[Common.VbecsTables.RackLot.TestWithName].ToString() == "")
						{
							drLotNumber["TestWithReagent"] = true;
						}
						else
						{
							drLotNumber["TestWithReagent"] = false;
						}
						drLotNumber[Common.VbecsTables.Reagent.InspectionIndicator] = drDailyQCReagentType[Common.VbecsTables.Reagent.InspectionIndicator];
						drLotNumber["Insert"] = false;
					}
					else
					{
						CheckPreviousTests(drLotNumber, i);
						drLotNumber["Insert"] = true;
					}

					if (drDailyQCReagentType.IsNull(Common.VbecsTables.RackLot.ReactivityPhaseCode) == false)
					{
						_dtLotNumbers[i].Rows.InsertAt(drLotNumber, lastTestableReagent);
						lastTestableReagent++;
					}
					else
					{
						_dtLotNumbers[i].Rows.Add(drLotNumber);
					}
				}
			}

			if (dailyQcWorklistGuid == Guid.Empty ||
				partiallyTestedIndicator == false)
			{
				//adding testwith reagents to the list
				for(int i=0 ; i<nNumberOfRacks ; i++)
				{
					nNumberOfLots = this._dtLotNumbers[i].Rows.Count;
					for(int j=0 ; j<nNumberOfLots ; j++)
					{
						if ((int)this._dtLotNumbers[i].Rows[j][Common.VbecsTables.RackLot.TestWithId] != 0)
						{
							drReagentType = dtReagentTypes.Select(Common.VbecsTables.ReagentType.ReagentTypeId.ToString() + "= " + (int)this._dtLotNumbers[i].Rows[j][Common.VbecsTables.RackLot.TestWithId]);
							drTestWithLotNumber = this._dtLotNumbers[i].Select(Common.VbecsTables.ReagentType.ReagentTypeId.ToString() + "= " + (int)this._dtLotNumbers[i].Rows[j][Common.VbecsTables.RackLot.TestWithId]);

							//found reagent type and there is no record with such ReagentTypeId in the LotNumber table
							if (drReagentType.Length > 0 && drTestWithLotNumber.Length == 0)
							{
								DataRow drLotNumber = _dtLotNumbers[i].NewRow();

								//for A1 and B Cells show "Reverse ABO Typing Cells" on LotNumber screen and use reagent type id = 62 for determining applicable lot numbers
								if (drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("A1 Cell") != -1 ||
									drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("B Cell") != -1)
								{
									drLotNumber["ReagentType"] = "Reverse ABO Typing Cells";
									drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
									drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
									drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = 62;
								}
								else
								{
									drLotNumber["ReagentType"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
									drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
									drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
									drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
								}

								drLotNumber[Common.VbecsTables.RackLot.TestWithName] = "";
								this.CheckPreviousTests(drLotNumber, i);
								drLotNumber[Common.VbecsTables.RackLot.ExpectedMinimumReactions] = "";
								drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText] = "";
								drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode] = System.DBNull.Value;
								drLotNumber["OverrideComment"] = string.Empty;
								drLotNumber["TestWithReagent"] = true;
								drLotNumber["Insert"] = true;

								_dtLotNumbers[i].Rows.Add(drLotNumber);
							}
						}
					}

					//adding enhancement media
					if (_dtDailyQCReagentTypes.Rows.Count > 0)
					{
						//primary
						if (_dtDailyQCReagentTypes.Rows[0].IsNull(Common.VbecsTables.DailyControl.PrimaryEnhancementMediaId) == false)
						{
							drEnhancementMedia = dtEnhancementMedia.Select(Common.VbecsTables.EnhancementMedia.EnhancementMediaId + "= " + _dtDailyQCReagentTypes.Rows[0][Common.VbecsTables.DailyControl.PrimaryEnhancementMediaId].ToString());
							if (drEnhancementMedia.Length > 0)
							{
								drReagentType = dtReagentTypes.Select(Common.VbecsTables.ReagentType.ReagentTypeId + "= " + drEnhancementMedia[0][Common.VbecsTables.ReagentType.ReagentTypeId].ToString());
								drTestWithLotNumber = this._dtLotNumbers[i].Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + drEnhancementMedia[0][Common.VbecsTables.ReagentType.ReagentTypeId].ToString());
						
								//found reagent type and there is no record with such ReagentTypeId in the LotNumber table
								if (drReagentType.Length > 0 && drTestWithLotNumber.Length == 0)
								{
									DataRow drLotNumber = _dtLotNumbers[i].NewRow();

									//for A1 and B Cells show "Reverse ABO Typing Cells" on LotNumber screen and use reagent type id = 62 for determining applicable lot numbers
									if (drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("A1 Cell") != -1 ||
										drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("B Cell") != -1)
									{
										drLotNumber["ReagentType"] = "Reverse ABO Typing Cells";
										drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
										drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
										drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = 62;
									}
									else
									{
										drLotNumber["ReagentType"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
										drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
										drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
										drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
									}

									drLotNumber[Common.VbecsTables.RackLot.TestWithName] = "";
									this.CheckPreviousTests(drLotNumber, i);
									drLotNumber[Common.VbecsTables.RackLot.ExpectedMinimumReactions] = "";
									drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText] = "";
									drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode] = System.DBNull.Value;
									drLotNumber["OverrideComment"] = string.Empty;
									drLotNumber["TestWithReagent"] = true;
									drLotNumber["Insert"] = true;

									_dtLotNumbers[i].Rows.Add(drLotNumber);
								}
							}
						}

						//secondary
						if (_dtDailyQCReagentTypes.Rows[0].IsNull(Common.VbecsTables.DailyControl.SecondaryEnhancementMediaId) == false)
						{
							drEnhancementMedia = dtEnhancementMedia.Select(Common.VbecsTables.EnhancementMedia.EnhancementMediaId + "=" + _dtDailyQCReagentTypes.Rows[0][Common.VbecsTables.DailyControl.SecondaryEnhancementMediaId].ToString());
							if (drEnhancementMedia.Length > 0)
							{
								drReagentType = dtReagentTypes.Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + drEnhancementMedia[0][Common.VbecsTables.ReagentType.ReagentTypeId].ToString());
								drTestWithLotNumber = this._dtLotNumbers[i].Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + drEnhancementMedia[0][Common.VbecsTables.ReagentType.ReagentTypeId].ToString());
						
								//found reagent type and there is no record with such ReagentTypeId in the LotNumber table
								if (drReagentType.Length > 0 && drTestWithLotNumber.Length == 0)
								{
									DataRow drLotNumber = _dtLotNumbers[i].NewRow();

									//for A1 and B Cells show "Reverse ABO Typing Cells" on LotNumber screen and use reagent type id = 62 for determining applicable lot numbers
									if (drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("A1 Cell") != -1 ||
										drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName].ToString().IndexOf("B Cell") != -1)
									{
										drLotNumber["ReagentType"] = "Reverse ABO Typing Cells";
										drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
										drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
										drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = 62;
									}
									else
									{
										drLotNumber["ReagentType"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
										drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
										drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
										drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
									}

									drLotNumber[Common.VbecsTables.RackLot.TestWithName] = "";
									this.CheckPreviousTests(drLotNumber, i);
									drLotNumber[Common.VbecsTables.RackLot.ExpectedMinimumReactions] = "";
									drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText] = "";
									drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode] = System.DBNull.Value;
									drLotNumber["OverrideComment"] = string.Empty;
									drLotNumber["TestWithReagent"] = true;
									drLotNumber["Insert"] = true;

									_dtLotNumbers[i].Rows.Add(drLotNumber);
								}
							}
						}

						//adding PS AHG
						drReagentType = dtReagentTypes.Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + (int)Common.ReagentType.PSAHG);
						drTestWithLotNumber = this._dtLotNumbers[i].Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + (int)Common.ReagentType.PSAHG);
						
						//found reagent type and there is no record with such ReagentTypeId in the LotNumber table
						if (drReagentType.Length > 0 && drTestWithLotNumber.Length == 0)
						{
							DataRow drLotNumber = _dtLotNumbers[i].NewRow();

							drLotNumber["ReagentType"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
							drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
							drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
							drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];

							drLotNumber[Common.VbecsTables.RackLot.TestWithName] = "";
							this.CheckPreviousTests(drLotNumber, i);
							drLotNumber[Common.VbecsTables.RackLot.ExpectedMinimumReactions] = "";
							drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText] = "";
							drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode] = System.DBNull.Value;
							drLotNumber["OverrideComment"] = string.Empty;
							drLotNumber["TestWithReagent"] = true;
							drLotNumber["Insert"] = true;

							_dtLotNumbers[i].Rows.Add(drLotNumber);
						}

						//adding CC
						drReagentType = dtReagentTypes.Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + (int)Common.ReagentType.CC);
						drTestWithLotNumber = this._dtLotNumbers[i].Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + (int)Common.ReagentType.CC);
						
						//found reagent type and there is no record with such ReagentTypeId in the LotNumber table
						if (drReagentType.Length > 0 && drTestWithLotNumber.Length == 0)
						{
							DataRow drLotNumber = _dtLotNumbers[i].NewRow();

							drLotNumber["ReagentType"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
							drLotNumber["ReagentTypeForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeName];
							drLotNumber["ReagentTypeIDForQCTemplate"] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];
							drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId] = drReagentType[0][Common.VbecsTables.ReagentType.ReagentTypeId];

							drLotNumber[Common.VbecsTables.RackLot.TestWithName] = "";
							this.CheckPreviousTests(drLotNumber, i);
							drLotNumber[Common.VbecsTables.RackLot.ExpectedMinimumReactions] = "";
							drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText] = "";
							drLotNumber[Common.VbecsTables.ReactivityPhase.ReactivityPhaseCode] = System.DBNull.Value;
							drLotNumber["OverrideComment"] = string.Empty;
							drLotNumber["TestWithReagent"] = true;
							drLotNumber["Insert"] = true;

							_dtLotNumbers[i].Rows.Add(drLotNumber);
						}
					}
				}
			}


			dgRack.DataSource = SetDataGridSourceDataTable();
			if (CheckForFilledTemplate() == true &&	CheckForDailyUse() == true)
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
			}

			if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
			{
				if ((bool)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true)
				{
					if (this.cbRackNotInUse.Checked == true)
						this._skipRackNotInUseCheckedChangedEvent = true;

					this.cbRackNotInUse.Checked = false;
					this.dgRack.Enabled = true;
				}
				else
				{
					if (this.cbRackNotInUse.Checked == false)
						this._skipRackNotInUseCheckedChangedEvent = true;

					this.cbRackNotInUse.Checked = true;
					this.dgRack.Enabled = false;
					//CR 2718
					this.btnCancel.Text = "Close";
					this.cbQCOffline.Enabled = false;
				}
			}
			else
			{
				if (this.cbRackNotInUse.Checked == true)
					this._skipRackNotInUseCheckedChangedEvent = true;

				this.cbRackNotInUse.Checked = false;
				this.dgRack.Enabled = true;
			}

			//CR 2718
			if (this.cbRackNotInUse.Checked == false)
			{
				if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
					{
						if (this.cbQCOffline.Checked == true)
							this._skipQCOfflineCheckedChangedEvent = true;

						this.cbQCOffline.Checked = false;
						this.dgRack.Enabled = true;
					}
					else
					{
						if (this.cbQCOffline.Checked == false)
							this._skipQCOfflineCheckedChangedEvent = true;

						this.cbQCOffline.Checked = true;
						this.dgRack.Enabled = false;

						this.btnCancel.Text = "Close";
						this.cbRackNotInUse.Enabled = false;
					}
				}
				else
				{
					if (this.cbQCOffline.Checked == true)
						this._skipQCOfflineCheckedChangedEvent = true;

					this.cbQCOffline.Checked = false;
					this.dgRack.Enabled = true;
				}
			}
		}

		/// <summary>
		/// Checks for previous tests for this reagent type and sets up the LotNumber row
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <param name="nRack"></param>
		private void CheckPreviousTests(DataRow drLotNumber, int nRack)
		{
			DataRow[] drRetestLotNumbers;
			DataRow[] drPreviousTestLotNumbers;
			bool rackTestedToday = false;

			//checking for existing lot numbers tested for this rack
			drPreviousTestLotNumbers = this._dtPreviousTestLotNumbers[nRack].Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId].ToString(), Common.VbecsTables.ReagentType.LastUpdateDate + Utility.DescSortOrderSuffix);
			if (this._dtRacks.Rows[nRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate) == false)
			{
				if (((DateTime)this._dtRacks.Rows[nRack][Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate]).Date == _currentDateTime.Date)
					rackTestedToday = true;
			}

			if (rackTestedToday == true)
			{
				drRetestLotNumbers = this._dtRetestLotNumbers[nRack].Select(Common.VbecsTables.ReagentType.ReagentTypeId + "=" + drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId].ToString(), Common.VbecsTables.ReagentType.LastUpdateDate + Utility.DescSortOrderSuffix);
				if (drRetestLotNumbers.Length == 0)
				{
					//reagent type has not yet been tested
					drLotNumber["Expired"] = string.Empty;
					drLotNumber[Common.VbecsTables.Reagent.ReagentGuid] = System.Guid.Empty;
					drLotNumber["Lot_Number"] = string.Empty;
					drLotNumber["Manufacturer"] = string.Empty;
					drLotNumber["Expiration Date"] = string.Empty;
					drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
					if (drLotNumber[Common.VbecsTables.RackLot.TestWithName].ToString() == "")
					{
						drLotNumber["TestWithReagent"] = true;
					}
					else
					{
						drLotNumber["TestWithReagent"] = false;
					}
				}
				else
				{
					//reagent type has been tested today
					drLotNumber["Expired"] = GetExpiredColumnValue((DateTime)drRetestLotNumbers[0][Common.VbecsTables.Reagent.LotExpirationDate]);
					drLotNumber[Common.VbecsTables.Reagent.ReagentGuid] = drRetestLotNumbers[0][Common.VbecsTables.Reagent.ReagentGuid];
					drLotNumber["Lot_Number"] = drRetestLotNumbers[0][Common.VbecsTables.Reagent.LotNumber];
					drLotNumber["Manufacturer"] = drRetestLotNumbers[0][Common.VbecsTables.Reagent.ReagentManufacturerName];
					drLotNumber["Expiration Date"] = drRetestLotNumbers[0][Common.VbecsTables.Reagent.LotExpirationDate].ToString();
					drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText] = drRetestLotNumbers[0][Common.VbecsTables.TestingMethod.TestingMethodText].ToString();
					if (drLotNumber[Common.VbecsTables.RackLot.TestWithName].ToString() == "")
					{
						drLotNumber["TestWithReagent"] = true;
					}
					else
					{
						drLotNumber["TestWithReagent"] = false;
					}
					drLotNumber[Common.VbecsTables.Reagent.InspectionIndicator] = drRetestLotNumbers[0][Common.VbecsTables.Reagent.InspectionIndicator];
				}
			}
			else if(drPreviousTestLotNumbers.Length == 0)
			{
				//reagent type has not yet been tested
				drLotNumber["Expired"] = string.Empty;
				drLotNumber[Common.VbecsTables.Reagent.ReagentGuid] = System.Guid.Empty;
				drLotNumber["Lot_Number"] = string.Empty;
				drLotNumber["Manufacturer"] = string.Empty;
				drLotNumber["Expiration Date"] = string.Empty;
				drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
				if (drLotNumber[Common.VbecsTables.RackLot.TestWithName].ToString() == "")
				{
					drLotNumber["TestWithReagent"] = true;
				}
				else
				{
					drLotNumber["TestWithReagent"] = false;
				}
			}
			else
			{
				//reagent type has been tested in a previous days
				drLotNumber["Expired"] = GetExpiredColumnValue((DateTime)drPreviousTestLotNumbers[0][Common.VbecsTables.Reagent.LotExpirationDate]);
				drLotNumber[Common.VbecsTables.Reagent.ReagentGuid] = drPreviousTestLotNumbers[0][Common.VbecsTables.Reagent.ReagentGuid];
				drLotNumber["Lot_Number"] = drPreviousTestLotNumbers[0][Common.VbecsTables.Reagent.LotNumber];
				drLotNumber["Manufacturer"] = drPreviousTestLotNumbers[0][Common.VbecsTables.Reagent.ReagentManufacturerName];
				drLotNumber["Expiration Date"] = drPreviousTestLotNumbers[0][Common.VbecsTables.Reagent.LotExpirationDate].ToString();
				drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText] = drPreviousTestLotNumbers[0][Common.VbecsTables.TestingMethod.TestingMethodText].ToString();
				if (drLotNumber[Common.VbecsTables.RackLot.TestWithName].ToString() == "")
				{
					drLotNumber["TestWithReagent"] = true;
				}
				else
				{
					drLotNumber["TestWithReagent"] = false;
				}
				drLotNumber[Common.VbecsTables.Reagent.InspectionIndicator] = drPreviousTestLotNumbers[0][Common.VbecsTables.Reagent.InspectionIndicator];
			}
		}

		private DataTable SetDataGridSourceDataTable()
		{
			int i;
			int nCount = 0;
			DataTable dtDataGridSource = new DataTable();
			dtDataGridSource.Columns.Add("Expired");
			dtDataGridSource.Columns.Add(Common.VbecsTables.ReagentType.ReagentTypeId);
			dtDataGridSource.Columns.Add("ReagentType");
			dtDataGridSource.Columns.Add("Lot_Number");
			dtDataGridSource.Columns.Add("Manufacturer");
			dtDataGridSource.Columns.Add("Expiration Date");
			dtDataGridSource.Columns.Add(Common.VbecsTables.TestingMethod.TestingMethodText);

			foreach(DataRow drLot in this._dtLotNumbers[this._nActiveRack].Rows)
			{
				//check if the reagent type is already in DataGridSource table
				nCount =dtDataGridSource.Rows.Count;
				for(i=0; i<nCount; i++)
				{
					if (dtDataGridSource.Rows[i][Common.VbecsTables.ReagentType.ReagentTypeId].ToString() == drLot[Common.VbecsTables.ReagentType.ReagentTypeId].ToString())
						break;
				}

				//Reagent Type is not yet in DataGridSource table
				if (i == dtDataGridSource.Rows.Count)
				{
					DataRow drDataGridSource = dtDataGridSource.NewRow();
					drDataGridSource["Expired"] = drLot["Expired"];
					drDataGridSource[Common.VbecsTables.ReagentType.ReagentTypeId] = drLot[Common.VbecsTables.ReagentType.ReagentTypeId];
					drDataGridSource["ReagentType"] = drLot["ReagentType"];
					drDataGridSource["Lot_Number"] = drLot["Lot_Number"];
					drDataGridSource["Manufacturer"] = drLot["Manufacturer"];
					if (drLot["Expiration Date"].ToString() != "")
					{
						drDataGridSource["Expiration Date"] = Common.VBECSDateTime.FormatDateTimeString(drLot["Expiration Date"]);
					}
					else
					{
						drDataGridSource["Expiration Date"] = drLot["Expiration Date"].ToString();
					}
					drDataGridSource[Common.VbecsTables.TestingMethod.TestingMethodText] = drLot[Common.VbecsTables.TestingMethod.TestingMethodText];
					dtDataGridSource.Rows.Add(drDataGridSource);
				}
			}
			return dtDataGridSource;
		}

		/// <summary>
		/// Checks the lot expiration date and returns the proper value for Expired column
		/// </summary>
		/// <param name="LotExpirationDate"></param>
		/// <returns></returns>
		private string GetExpiredColumnValue(DateTime LotExpirationDate)
		{
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if(LotExpirationDate >= currentDate)
			{
				if ( ((System.TimeSpan)(LotExpirationDate - currentDate)).Days < 1)
				{
					return "W";
				}
				else
				{
					return "V";
				}
			}
			else
			{
				return "E";
			}
		}

		/// <summary>
		/// Checks if the reagent entered in the row has expired
		/// BR_28.24
		/// </summary>
		/// <param name="drLotNumber"></param>
		private bool CheckForExpiredAntisera(System.Data.DataRow drLotNumber)
		{
			DateTime LotExpirationDate;
			DialogResult result = DialogResult.Yes;
			string sReagentTypeID;
			DataRow[] drSameReagentTypes;
			DataRow drDGSourceSameReagentType;
			int nCount = 0;
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

		
			sReagentTypeID = drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId].ToString();
			drSameReagentTypes = _dtLotNumbers[this._nActiveRack].Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + sReagentTypeID + "'");
			drDGSourceSameReagentType = ((DataTable)dgRack.DataSource).Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + sReagentTypeID + "'")[0];
			

			if(drLotNumber.IsNull("Expiration Date") == false)
			{
				LotExpirationDate = System.Convert.ToDateTime(drLotNumber["Expiration Date"]);
			}
			else
			{
				LotExpirationDate = DateTime.MaxValue;
			}

			if(LotExpirationDate >= currentDate)
			{
				if ( ((System.TimeSpan)(LotExpirationDate - currentDate)).Days < 1)
				{
					Common.Utility.MessageBeep();
					result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.AntiseraWillExpire(Common.VBECSDateTime.FormatDateTimeString(LotExpirationDate)));
					if (result != DialogResult.Yes)
					{
						nCount = drSameReagentTypes.Length;
						for(int i=0; i<nCount; i++)
						{
							drSameReagentTypes[i]["Expired"] = string.Empty;
							drSameReagentTypes[i]["Lot_Number"] = string.Empty;
							drSameReagentTypes[i]["Manufacturer"] = string.Empty;
							drSameReagentTypes[i]["Expiration Date"] = string.Empty;
							drSameReagentTypes[i][Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
                            //CR 3292 replaced string.Empty with Guid.Empty to prevent system crash
							drSameReagentTypes[i][Common.VbecsTables.Reagent.ReagentGuid] = Guid.Empty;
						}

						drDGSourceSameReagentType["Expired"] = string.Empty;
						drDGSourceSameReagentType["Lot_Number"] = string.Empty;
						drDGSourceSameReagentType["Manufacturer"] = string.Empty;
						drDGSourceSameReagentType["Expiration Date"] = string.Empty;
						drDGSourceSameReagentType[Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
						cmbBox.Text = string.Empty;
						cmbBoxTestingMethod.Text = string.Empty;
						return false;
					}
				}
				drLotNumber["ReagentExpiredException"] = DBNull.Value;
			}
			else
			{
				DlgExpiredAntisera dlg = new DlgExpiredAntisera(this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackName].ToString(), drSameReagentTypes);

				dlg.ShowDialogFromLockedParent(this,false);
				if (dlg.DialogResult != DialogResult.Yes)       //TODO: Check for Abort(lockexpired)?
				{
					nCount = drSameReagentTypes.Length;
					for(int i=0; i<nCount; i++)
					{
						drSameReagentTypes[i]["Expired"] = string.Empty;
						drSameReagentTypes[i]["Lot_Number"] = string.Empty;
						drSameReagentTypes[i]["Manufacturer"] = string.Empty;
						drSameReagentTypes[i]["Expiration Date"] = string.Empty;
						drSameReagentTypes[i][Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
                        //CR 3292 replaced string.Empty with Guid.Empty to prevent system crash
                        drSameReagentTypes[i][Common.VbecsTables.Reagent.ReagentGuid] = Guid.Empty;
					}

					DataRow drRemovedLotNumber = this._dtRemovedLotNumbers.NewRow();

					drRemovedLotNumber["Lot_Number"] = drDGSourceSameReagentType["Lot_Number"];
					drRemovedLotNumber["Manufacturer"] = drDGSourceSameReagentType["Manufacturer"];
						
					this._dtRemovedLotNumbers.Rows.Add(drRemovedLotNumber);

					drDGSourceSameReagentType["Expired"] = string.Empty;
					drDGSourceSameReagentType["Lot_Number"] = string.Empty;
					drDGSourceSameReagentType["Manufacturer"] = string.Empty;
					drDGSourceSameReagentType["Expiration Date"] = string.Empty;
					drDGSourceSameReagentType[Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
					cmbBox.Text = string.Empty;
					cmbBoxTestingMethod.Text = string.Empty;
					return false;
				}
				else
				{
					drLotNumber["OverrideComment"] = dlg.Comment;
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_reagent_QC, drLotNumber["OverrideComment"].ToString(), Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionQC((Guid)drLotNumber[Common.VbecsTables.Reagent.ReagentGuid], (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid], Guid.Empty, Guid.Empty, "", "", "", this._testingTech);
					drLotNumber["ReagentExpiredException"] = exRep;
				}
			}

			return true;
		}

		/// <summary>
		/// Checks the inspection indicator on the reagent
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForSatisfactoryReagent(DataRow drLotNumber)
		{
			DialogResult result;
			string sReagentTypeID;
			int nCount = 0;
			DataRow[] drSameReagentTypes;
			DataRow drDGSourceSameReagentType;

			
			sReagentTypeID = drLotNumber[Common.VbecsTables.ReagentType.ReagentTypeId].ToString();
			drSameReagentTypes = _dtLotNumbers[this._nActiveRack].Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + sReagentTypeID + "'");
			drDGSourceSameReagentType = ((DataTable)dgRack.DataSource).Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + sReagentTypeID + "'")[0];
			//			}

			if ((bool)drLotNumber[Common.VbecsTables.Reagent.InspectionIndicator] == false)
			{
				result = GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnsatisfactoryReagent(drLotNumber["Manufacturer"].ToString(), drLotNumber["Lot_Number"].ToString(), drLotNumber["Expiration Date"].ToString()));
				nCount =drSameReagentTypes.Length;
				for(int i=0; i<nCount; i++)
				{
					drLotNumber["Expired"] = string.Empty;
					drLotNumber["Lot_Number"] = string.Empty;
					drLotNumber["Manufacturer"] = string.Empty;
					drLotNumber["Expiration Date"] = string.Empty;
					drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
                    //CR 3292 replaced string.Empty with Guid.Empty to prevent system crash
                    drLotNumber[Common.VbecsTables.Reagent.ReagentGuid] = Guid.Empty;
					cmbBox.Text = string.Empty;
					cmbBoxTestingMethod.Text = string.Empty;
				}
				drDGSourceSameReagentType["Expired"] = string.Empty;
				drDGSourceSameReagentType["Lot_Number"] = string.Empty;
				drDGSourceSameReagentType["Manufacturer"] = string.Empty;
				drDGSourceSameReagentType["Expiration Date"] = string.Empty;
				drDGSourceSameReagentType[Common.VbecsTables.TestingMethod.TestingMethodText] = string.Empty;
				cmbBox.Text = ((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber][3].ToString();
				cmbBoxTestingMethod.Text = ((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber][6].ToString();
				return false;
			}
			return true;
		}

		/// <summary>
		/// Checks if the user entered all required lot numbers
		/// </summary>
		private bool CheckForFilledTemplate()
		{
			//CR 2718 added check for QCOfflineIndicator
			for (int i=0 ; i<_dtRacks.Rows.Count ; i++)
			{
				if (_dtRacks.Rows[i].IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false &&
					_dtRacks.Rows[i].IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)_dtRacks.Rows[i][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true &&
						(bool)_dtRacks.Rows[i][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
					{
						foreach(DataRow drLotNumber in _dtLotNumbers[i].Rows)
						{
							if (drLotNumber["Lot_Number"].ToString().Trim() == string.Empty ||
								drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText].ToString().Trim() == string.Empty)
							{
								return false;
							}
						}
					}
				}
				else
				{
					foreach(DataRow drLotNumber in _dtLotNumbers[i].Rows)
					{
						if (drLotNumber["Lot_Number"].ToString().Trim() == string.Empty ||
							drLotNumber[Common.VbecsTables.TestingMethod.TestingMethodText].ToString().Trim() == string.Empty)
						{
							return false;
						}
					}
				}
			}
			return true;
		}

		/// <summary>
		/// RemoveTab
		/// </summary>
		/// <param name="tabIndex"></param>
		public void RemoveTab(int tabIndex)
		{
			int newIndex = 0;
			int PreviousNumberOfTabs = this.tabLotNumbers.TabCount;
			int nNumberOfRacks = 0;
			int TabPageIndex = 0;

			DataTable newDTRacks = this._dtRacks.Clone();
			DataTable[] newDTLotNumbers = new DataTable[this._dtLotNumbers.Length - 1];

			this.ReleaseLocks((System.Guid)this._dtRacks.Rows[tabIndex][Common.VbecsTables.Rack.RackGuid]);

			for(int i=0; i<this.tabLotNumbers.TabPages.Count; i++)
			{
				if (i != tabIndex)
				{
					newDTLotNumbers[newIndex] = this._dtLotNumbers[i];
					newDTRacks.Rows.Add(this._dtRacks.Rows[i].ItemArray);
					newIndex++;
				}
			}
			this._dtLotNumbers = newDTLotNumbers;
			this._dtRacks = newDTRacks;

			foreach(DataRow drRack in _dtRacks.Rows)
			{
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
				{
					if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true)
						nNumberOfRacks++;
				}
				else
				{
					nNumberOfRacks++;
				}
			}

			//creating new tabs
			this.pageRacks = new System.Windows.Forms.TabPage[nNumberOfRacks];

			foreach(DataRow drRack in _dtRacks.Rows)
			{
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
				{
					if((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true)
					{
						this.pageRacks[TabPageIndex] = new System.Windows.Forms.TabPage(drRack["RackName"].ToString());
						this.pageRacks[TabPageIndex].Tag = TabPageIndex;
						this.pageRacks[TabPageIndex].Location = new System.Drawing.Point(4, 23);
						this.pageRacks[TabPageIndex].Size = new System.Drawing.Size(488, 375);
						this.pageRacks[TabPageIndex].TabIndex = TabPageIndex;
						TabPageIndex++;
					}
				}
				else
				{
					this.pageRacks[TabPageIndex] = new System.Windows.Forms.TabPage(drRack["RackName"].ToString());
					this.pageRacks[TabPageIndex].Tag = TabPageIndex;
					this.pageRacks[TabPageIndex].Location = new System.Drawing.Point(4, 23);
					this.pageRacks[TabPageIndex].Size = new System.Drawing.Size(488, 375);
					this.pageRacks[TabPageIndex].TabIndex = TabPageIndex;
					TabPageIndex++;
				}
			}

			this.tabLotNumbers.TabPages.AddRange(this.pageRacks);

			//removing old tabs
			for (int i=PreviousNumberOfTabs-1 ; i>=0 ; i--)
			{
				this.tabLotNumbers.TabPages.RemoveAt(i);
			}


			this._nActiveRack = 0;
			this.tabLotNumbers.SelectedIndex = 0;
		}

		private void dgRack_CurrentCellChanged(object sender, System.EventArgs e)
		{
			string sLotNumber;

			if (dgRack.CurrentCell.ColumnNumber == 3)
			{
				try
				{
					_dtReagents = BOL.Reagent.GetReagentsByType(LogonUser.LogonUserDivisionCode, System.Convert.ToInt32(((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.ReagentType.ReagentTypeId]));
					_dtReagents.CaseSensitive = true;
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				}

				cmbBox.Items.Clear();

				foreach (DataRow drReagent in _dtReagents.Rows)
				{
					if (this._dtRemovedLotNumbers.Select("Lot_Number = '" + drReagent[Common.VbecsTables.Reagent.LotNumber].ToString().Replace("'", "''") + "' AND Manufacturer = '" + drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString().Replace("'", "''") + "'").Length == 0)
						cmbBox.Items.Add(drReagent[Common.VbecsTables.Reagent.LotNumber]);
				}

				sLotNumber = ((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber]["Lot_Number"].ToString();
				if (sLotNumber != string.Empty)
				{
					//					_bCurrentCellChanged = true;
					cmbBox.Text = sLotNumber;
				}
				else
				{
					//					_bCurrentCellChanged = false;
					cmbBox.Text = string.Empty;
				}
				cmbBox.Show();
				cmbBox.Focus();
			}
			else if (dgRack.CurrentCell.ColumnNumber == 6)
			{
				if (((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber]["Lot_Number"].ToString().Trim() != "")
				{
					//					_bCurrentCellChanged = true;
					try
					{
						_dtReagents = BOL.Reagent.GetReagentsByType(LogonUser.LogonUserDivisionCode, System.Convert.ToInt32(((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.ReagentType.ReagentTypeId]));
					}
					catch (Exception err)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
					}

					cmbBoxTestingMethod.Text = ((DataTable)dgRack.DataSource).Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.TestingMethod.TestingMethodText].ToString();
					if (cmbBoxTestingMethod.Text == "")
						cmbBoxTestingMethod.SelectedIndex = -1;
					cmbBoxTestingMethod.Show();
					cmbBoxTestingMethod.Focus();
				}
				else
				{
					dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 3);
				}
			}
			else if (dgRack.CurrentCell.ColumnNumber > 3)
			{
				dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 6);
			}
			else if (dgRack.CurrentCell.ColumnNumber < 3)
			{
				dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 3);
			}

		}

		private void cmbBox_Leave(object sender, System.EventArgs e)
		{
			int nRow;
			int nCount;
			string sReagentTypeID;
			DataRow[] drSameReagentTypes;
			DataRow[] drTestWithReagentTypes;
			DataTable dtGridDataSource;

			if (cmbBox.SelectedIndex == -1)
				return;

		
			dtGridDataSource = (DataTable)dgRack.DataSource;
			if (dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Lot_Number"].ToString() != cmbBox.Text)
			{
                if (_dtReagents.Select(Common.VbecsTables.Reagent.LotNumber + " = '" + cmbBox.Text.Replace("'", "''") + "'").Length == 0)
					return;

                DataRow drReagent = _dtReagents.Select(Common.VbecsTables.Reagent.LotNumber + " = '" + cmbBox.Text.Replace("'", "''") + "'")[0];
				sReagentTypeID = dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.ReagentType.ReagentTypeId].ToString();
				drSameReagentTypes = _dtLotNumbers[this._nActiveRack].Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + sReagentTypeID + "'");
				//CR 2696 - identify all TestWith rows that will be affected by changed lot number
				drTestWithReagentTypes = _dtLotNumbers[this._nActiveRack].Select(Common.VbecsTables.RackLot.TestWithId + " = '" + sReagentTypeID + "'");
				nCount = drSameReagentTypes.Length;
				for(int i = 0; i < nCount; i++)
				{
					drSameReagentTypes[i]["Expired"] = GetExpiredColumnValue((DateTime)drReagent[Common.VbecsTables.Reagent.LotExpirationDate]);
					drSameReagentTypes[i]["Lot_Number"] = cmbBox.Text;
					drSameReagentTypes[i]["Manufacturer"] = drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName];
					drSameReagentTypes[i]["Expiration Date"] = drReagent[Common.VbecsTables.Reagent.LotExpirationDate];
					drSameReagentTypes[i][Common.VbecsTables.Reagent.ReagentGuid] = drReagent[Common.VbecsTables.Reagent.ReagentGuid];
					drSameReagentTypes[i][Common.VbecsTables.Reagent.InspectionIndicator] = drReagent[Common.VbecsTables.Reagent.InspectionIndicator];
					
					//if the user selects lot number for which qc result exist
					if (this._dtDailyQCReagentTypes.Columns.Contains(Common.VbecsTables.Reagent.LotNumber) == true)
					{
                        if (this._dtDailyQCReagentTypes.Select(Common.VbecsTables.Reagent.LotNumber + " = '" + cmbBox.Text.Replace("'", "''") + "'").Length > 0)
						{
							drSameReagentTypes[i]["Insert"] = false;
						}
						else
						{
							drSameReagentTypes[i]["Insert"] = true;
						}
					}
				}

				dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Expired"] = GetExpiredColumnValue((DateTime)drReagent[Common.VbecsTables.Reagent.LotExpirationDate]);
				dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Lot_Number"] = cmbBox.Text;
				dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Manufacturer"] = drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName];
				dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Expiration Date"] = Common.VBECSDateTime.FormatDateTimeString(drReagent[Common.VbecsTables.Reagent.LotExpirationDate]);

				if (CheckForExpiredAntisera(drSameReagentTypes[0]) == true)
				{
					if (CheckForSatisfactoryReagent(drSameReagentTypes[0]) == true)
					{
						nCount = drSameReagentTypes.Length;
						for(int i = 0; i < nCount; i++)
						{
							for (nRow = 0; nRow < this._dtLotNumbers[this._nActiveRack].Rows.Count; nRow++)
							{
								if (this._dtLotNumbers[this._nActiveRack].Rows[nRow].Equals(drSameReagentTypes[i]))
									break;
							}
							((FrmDailyReagentRackQC)this.Tag).SetUpRackTestRow(this._nActiveRack, nRow);
						}

						//CR 2696 - update rows that were affected by changed lot number
						nCount = drTestWithReagentTypes.Length;
						for(int i = 0; i < nCount; i++)
						{
							for (nRow = 0; nRow < this._dtLotNumbers[this._nActiveRack].Rows.Count; nRow++)
							{
								if (this._dtLotNumbers[this._nActiveRack].Rows[nRow].Equals(drTestWithReagentTypes[i]))
									break;
							}
							((FrmDailyReagentRackQC)this.Tag).SetUpRackTestRow(this._nActiveRack, nRow);
						}

					}
				}

				if (CheckForFilledTemplate() == true &&	CheckForDailyUse() == true)
				{
					this.btnOK.EnabledButton = true;
					this.btnOK.SetToolTip("");
				}
				else
				{
					this.btnOK.EnabledButton = false;
					this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
				}
			}
			//			else
			//			{
			//				_bCurrentCellChanged = false;
			//			}
		}

		private void cmbBoxTestingMethod_Leave(object sender, System.EventArgs e)
		{
			int nRow;
			string sReagentTypeID;
			DataRow[] drSameReagentTypes;
			int nCount = 0;

			DataTable dtGridDataSource = (DataTable)dgRack.DataSource;
			if (this.cmbBoxTestingMethod.SelectedIndex != -1 &&
				dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.TestingMethod.TestingMethodText].ToString() != this.cmbBoxTestingMethod.Text)
			{
				dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.TestingMethod.TestingMethodText] = this.cmbBoxTestingMethod.Text;

                if (_dtReagents.Select(Common.VbecsTables.Reagent.LotNumber + " = '" + dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Lot_Number"].ToString().Replace("'", "''") + "'").Length > 0)
				{
                    DataRow drReagent = _dtReagents.Select(Common.VbecsTables.Reagent.LotNumber + " = '" + dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber]["Lot_Number"].ToString().Replace("'", "''") + "'")[0];
					sReagentTypeID = dtGridDataSource.Rows[dgRack.CurrentCell.RowNumber][Common.VbecsTables.ReagentType.ReagentTypeId].ToString();
					drSameReagentTypes = _dtLotNumbers[this._nActiveRack].Select(Common.VbecsTables.ReagentType.ReagentTypeId + " = '" + sReagentTypeID + "'");
					nCount = drSameReagentTypes.Length;
					for(int i = 0; i < nCount; i++)
					{
						drSameReagentTypes[i][Common.VbecsTables.TestingMethod.TestingMethodText] = this.cmbBoxTestingMethod.Text;
					}
					nCount = drSameReagentTypes.Length;
					for(int i = 0;	i < nCount; i++)
					{
						for (nRow = 0; nRow < this._dtLotNumbers[this._nActiveRack].Rows.Count; nRow++)
						{
							if (this._dtLotNumbers[this._nActiveRack].Rows[nRow].Equals(drSameReagentTypes[i]))
								break;
						}

						//fix for the crash that occurs sometimes when the leave event gets fired even though nothing was selected
						if (this.cmbBoxTestingMethod.Text.Trim() == "")
							return;

						((FrmDailyReagentRackQC)this.Tag).UpdateTestingMethod(this._nActiveRack, nRow, this.cmbBoxTestingMethod.Text.Substring(0, 1));
					}

					if (CheckForFilledTemplate() == true &&	CheckForDailyUse() == true)
					{
						this.btnOK.EnabledButton = true;
						this.btnOK.SetToolTip("");
					}
					else
					{
						this.btnOK.EnabledButton = false;
						this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
					}
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			//((FrmDailyReagentRackQC)this.Tag).Close();
			this.Close();
		}

		private void tabLotNumbers_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this._nActiveRack = (int)((System.Windows.Forms.TabControl)sender).SelectedTab.Tag;
			dgRack.DataSource = SetDataGridSourceDataTable();
			if (_dtLotNumbers[_nActiveRack].Rows.Count > 0)
			{
				dgRack.SetCurrentCell(0, 0);
				cmbBox.Show();
				cmbBox.Focus();
			}
			
			if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
			{
				if ((bool)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true)
				{
					if (this.cbRackNotInUse.Checked == true)
						this._skipRackNotInUseCheckedChangedEvent = true;

					this.cbRackNotInUse.Checked = false;
					this.dgRack.Enabled = true;
					//CR 2718
					this.btnCancel.Text = "Cancel";
					this.cbQCOffline.Enabled = true;
				}
				else
				{
					if (this.cbRackNotInUse.Checked == false)
						this._skipRackNotInUseCheckedChangedEvent = true;

					this.cbRackNotInUse.Enabled = true;
					this.cbRackNotInUse.Checked = true;
					this.dgRack.Enabled = false;
					//CR 2718
					this.btnCancel.Text = "Close";

					if (this.cbQCOffline.Checked == true)
					{
						//uncheck QCOffline here since the next if statement will not be executed
						this._skipQCOfflineCheckedChangedEvent = true;
						this.cbQCOffline.Checked = false;
					}

					this.cbQCOffline.Enabled = false;
				}
			}
			else
			{
				if (this.cbRackNotInUse.Checked == true)
					this._skipRackNotInUseCheckedChangedEvent = true;

				this.cbRackNotInUse.Checked = false;
				this.dgRack.Enabled = true;
				//CR 2718
				this.btnCancel.Text = "Cancel";
				this.cbQCOffline.Enabled = true;
			}

			//CR 2718
			if (this.cbRackNotInUse.Checked == false)
			{
				if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
					{
						if (this.cbQCOffline.Checked == true)
							this._skipQCOfflineCheckedChangedEvent = true;

						this.cbQCOffline.Checked = false;
						this.dgRack.Enabled = true;
						this.btnCancel.Text = "Cancel";
						this.cbRackNotInUse.Enabled = true;
					}
					else
					{
						if (this.cbQCOffline.Checked == false)
							this._skipQCOfflineCheckedChangedEvent = true;

						this.cbQCOffline.Checked = true;
						this.dgRack.Enabled = false;
						this.btnCancel.Text = "Close";
						this.cbRackNotInUse.Enabled = false;
					}
				}
				else
				{
					if (this.cbQCOffline.Checked == true)
						this._skipQCOfflineCheckedChangedEvent = true;

					this.cbQCOffline.Checked = false;
					this.dgRack.Enabled = true;
					this.btnCancel.Text = "Cancel";
					this.cbRackNotInUse.Enabled = true;
				}
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			for (int i=0 ; i<_dtLotNumbers.Length ; i++)
			{
				bool dailyUse = false;
				bool qcOffline = false;

				if (this._dtRacks.Rows[i].IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
				{
					if ((bool)this._dtRacks.Rows[i][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true)
					{
						dailyUse = true;
					}
				}
				else
				{
					dailyUse = true;
				}

				if (this._dtRacks.Rows[i].IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)this._dtRacks.Rows[i][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == true)
					{
						qcOffline = true;
					}
				}
				else
				{
					qcOffline = true;
				}
				
				if (dailyUse == true && qcOffline == false)
				{
					this.tabLotNumbers.SelectedIndex = i;
					this.dgRack.SetCurrentCell(0, 1);
					foreach(DataRow drLotNumber in _dtLotNumbers[i].Rows)
					{
						if (drLotNumber["OverrideComment"].ToString().Trim() == string.Empty)
						{
							if (CheckForExpiredAntisera(drLotNumber) == false || CheckForSatisfactoryReagent(drLotNumber) == false)
							{
								this.btnOK.EnabledButton = false;
								this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
								this.tabLotNumbers.SelectedIndex = i;
								return;
							}
						}
					}
				}
			}

			((FrmDailyReagentRackQC)this.Tag).Show();
			((FrmDailyReagentRackQC)this.Tag).FocusOnTheFirstEditableCell();
			this.Enabled = false;
		}

		private void cmbBox_KeyDown(object sender, KeyEventArgs e)
		{
//						if (e.KeyCode == Keys.Enter)
//						{
			//				if(dgRack.CurrentCell.RowNumber < ((DataTable)dgRack.DataSource).Rows.Count - 1)
			//				{
			//					dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber + 1, dgRack.CurrentCell.ColumnNumber);
			//					cmbBox.Show();
			//					cmbBox.Focus();
			//				}
			//				else
			//				{
			//					cmbBox.Hide();
			//					this.btnOK.Focus();
			//				}
//						}
		}

		private void FrmRecordLotNumbers_Load(object sender, System.EventArgs e)
		{
            //CR 1911
            _isLoading = false;

			if (_dtLotNumbers[0].Rows.Count > 0)
			{
				dgRack.SetCurrentCell(0, 3);
			}
			cmbBox.Show();
			cmbBox.Focus();
			//Setting initial dirty value to false
			this.IsDirty=false;
		}

		/// <summary>
		/// Checks if at least one rack is set for daily use
		/// </summary>
		private bool CheckForDailyUse()
		{
			//CR 2718 added check for QCOffline Indicator
			foreach(DataRow drRack in this._dtRacks.Rows)
			{
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false &&
					drRack.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == true &&
						(bool)drRack[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == false)
					{
						return true;
					}
				}
				else
				{
					return true;
				}
			}
			return false;
		}

		private void cbRackNotInUse_CheckedChanged(object sender, System.EventArgs e)
		{
			if (_skipRackNotInUseCheckedChangedEvent == true)
			{
				_skipRackNotInUseCheckedChangedEvent = false;
				return;
			}

			Guid dailyQcWorklistGuid = Guid.Empty;
			byte[] rowVersion = new byte[0];
			Guid rackGuid = (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid];
			DateTime dailyAlertTime = (DateTime)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyControl.DailyAlertTime];

			DateTime dailyQcExpirationDateTime = new DateTime();
			int testTime = _testDateTime.Hour * 60 + _testDateTime.Minute;
			int alertTime = dailyAlertTime.Hour * 60 + dailyAlertTime.Minute;

			//the test was performed before daily alert time (meaning that it will expire today)
			if (testTime - alertTime < 0)
			{
				dailyQcExpirationDateTime = new DateTime(_testDateTime.Year, _testDateTime.Month, _testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
			}
			else if ((testTime - alertTime > 0) && (testTime - alertTime < 1440))
			{
				dailyQcExpirationDateTime = new DateTime(_testDateTime.Year, _testDateTime.Month, _testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
				dailyQcExpirationDateTime = dailyQcExpirationDateTime.AddDays(1);
			}
			else
			{
				dailyQcExpirationDateTime = new DateTime(_testDateTime.Year, _testDateTime.Month, _testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
				dailyQcExpirationDateTime = dailyQcExpirationDateTime.AddDays(2);
			}

			if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == false)
			{
				dailyQcWorklistGuid = (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid];
				rowVersion = (byte[])this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.RowVersion];
			}

			try
			{
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("rack daily use"));
				if (result == DialogResult.No)
				{
					if (this.cbRackNotInUse.Checked == true)
					{
						_skipRackNotInUseCheckedChangedEvent = true;
						this.cbRackNotInUse.Checked = false;
					}
					else
					{
						_skipRackNotInUseCheckedChangedEvent = true;
						this.cbRackNotInUse.Checked = true;
					}
					
					return;
				}
			
				if (this.cbRackNotInUse.Checked == true)
				{
					if (BOL.Rack.UpdateRackDailyUse(dailyQcWorklistGuid, 
						false, false, Common.UpdateFunction.UC028FrmRecordLotNumbers,
						rowVersion, rackGuid, dailyQcExpirationDateTime) == true)
					{
						//CR 1441
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.DailyRackQualityControlQC);
						if(dt!= null)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] = false;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] = false;
						this.dgRack.Enabled = false;
						//CR 2718
						this.btnCancel.Text = "Close";
						this.cbQCOffline.Enabled = false;

						DataTable racks = BOL.Rack.GetDailyQCRacks(this._testDateTime);
						if (racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'").Length > 0)
							this._dtRacks.Rows[this._nActiveRack].ItemArray =  racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'")[0].ItemArray;
					}
				}
				else
				{
					if (BOL.Rack.UpdateRackDailyUse(dailyQcWorklistGuid, 
						true, false, Common.UpdateFunction.UC028FrmRecordLotNumbers,
						rowVersion, rackGuid, dailyQcExpirationDateTime) == true)
					{
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] = true;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] = false;
						this.dgRack.Enabled = true;
						//CR 2718
						this.btnCancel.Text = "Cancel";
						this.cbQCOffline.Enabled = true;

						DataTable racks = BOL.Rack.GetDailyQCRacks(this._testDateTime);
						if (racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'").Length > 0)
							this._dtRacks.Rows[this._nActiveRack].ItemArray =  racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'")[0].ItemArray;

						
					}
				}
			}
			catch (RowVersionException)
			{
				//CR2077?
				cbRackNotInUse.Enabled = false;
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
			


			if (CheckForFilledTemplate() == true &&	CheckForDailyUse() == true)
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
			}
		}

		private void FrmRecordLotNumbers_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			((FrmDailyReagentRackQC)this.Tag).Dispose();
		}
 
		/// <summary>
		/// Controls the movement of the cursor on the datagrid.
		/// </summary>
		private void SetNextCell()
		{
			int row = this.dgRack.CurrentCell.RowNumber;
			int col = this.dgRack.CurrentCell.ColumnNumber;

			if (row == dgRack.VisibleRowCount - 1)
			{
				if (col == 3)
				{
					this.dgRack.SetCurrentCell(0, 6);
				}
				else if (col == 6)
				{
					this.dgRack.SetCurrentCell(0, 3);
				}
			}
			else
			{
				this.dgRack.SetCurrentCell(row + 1, col);
			}
		}

		private void dgRack_LostFocus(object sender, EventArgs e)
		{
			if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
			{
				if (((VbecsGridEventArgs)e).TabKeyPressed)
				{
					this.SelectNextControl(this.dgRack,true,true,false,false);
				}
			}
		}

		private void FrmRecordLotNumbers_SizeChanged(object sender, System.EventArgs e)
		{
            //CR 1911 Do not run this code if the form is loading. It prevents crashes when rack selection windows is maximized.
            if (!_isLoading)
            {
                //fixing problem with disappearing combo box when resizing the window
                if (dgRack.CurrentCell.ColumnNumber == 3)
                {
                    dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 6);
                    dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 3);
                }
                else
                {
                    dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 3);
                    dgRack.SetCurrentCell(dgRack.CurrentCell.RowNumber, 6);
                }
            }
		}

		//CR 2718
		private void cbQCOffline_CheckedChanged(object sender, System.EventArgs e)
		{
			if (_skipQCOfflineCheckedChangedEvent == true)
			{
				_skipQCOfflineCheckedChangedEvent = false;
				return;
			}

			Guid dailyQcWorklistGuid = Guid.Empty;
			byte[] rowVersion = new byte[0];
			Guid rackGuid = (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid];
			DateTime dailyAlertTime = (DateTime)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyControl.DailyAlertTime];

			DateTime dailyQcExpirationDateTime = new DateTime();
			int testTime = _testDateTime.Hour * 60 + _testDateTime.Minute;
			int alertTime = dailyAlertTime.Hour * 60 + dailyAlertTime.Minute;

			//the test was performed before daily alert time (meaning that it will expire today)
			if (testTime - alertTime < 0)
			{
				dailyQcExpirationDateTime = new DateTime(_testDateTime.Year, _testDateTime.Month, _testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
			}
			else if ((testTime - alertTime > 0) && (testTime - alertTime < 1440))
			{
				dailyQcExpirationDateTime = new DateTime(_testDateTime.Year, _testDateTime.Month, _testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
				dailyQcExpirationDateTime = dailyQcExpirationDateTime.AddDays(1);
			}
			else
			{
				dailyQcExpirationDateTime = new DateTime(_testDateTime.Year, _testDateTime.Month, _testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
				dailyQcExpirationDateTime = dailyQcExpirationDateTime.AddDays(2);
			}

			if (this._dtRacks.Rows[this._nActiveRack].IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid) == false)
			{
				dailyQcWorklistGuid = (Guid)this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid];
				rowVersion = (byte[])this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.RowVersion];
			}

			try
			{
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("QC Offline"));
				if (result == DialogResult.No)
				{
					if (this.cbQCOffline.Checked == true)
					{
						_skipQCOfflineCheckedChangedEvent = true;
						this.cbQCOffline.Checked = false;
					}
					else
					{
						_skipQCOfflineCheckedChangedEvent = true;
						this.cbQCOffline.Checked = true;
					}
					
					return;
				}
			
				if (this.cbQCOffline.Checked == true)
				{
					if (BOL.Rack.UpdateRackDailyUse(dailyQcWorklistGuid, 
						true, true, Common.UpdateFunction.UC028FrmRecordLotNumbers,
						rowVersion, rackGuid, dailyQcExpirationDateTime) == true)
					{
						//CR 1441
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.DailyRackQualityControlQC);
						if(dt!= null)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] = true;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] = true;
						this.dgRack.Enabled = false;
						//CR 2718
						this.btnCancel.Text = "Close";
						this.cbRackNotInUse.Enabled = false;

						DataTable racks = BOL.Rack.GetDailyQCRacks(this._testDateTime);
						if (racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'").Length > 0)
							this._dtRacks.Rows[this._nActiveRack].ItemArray =  racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'")[0].ItemArray;
					}
				}
				else
				{
					if (BOL.Rack.UpdateRackDailyUse(dailyQcWorklistGuid, 
						true, false, Common.UpdateFunction.UC028FrmRecordLotNumbers,
						rowVersion, rackGuid, dailyQcExpirationDateTime) == true)
					{
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] = false;
						this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] = true;
						this.dgRack.Enabled = true;
						//CR 2718
						this.btnCancel.Text = "Cancel";
						this.cbRackNotInUse.Enabled = true;

						DataTable racks = BOL.Rack.GetDailyQCRacks(this._testDateTime);
						if (racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'").Length > 0)
							this._dtRacks.Rows[this._nActiveRack].ItemArray =  racks.Select(Common.VbecsTables.Rack.RackGuid + " = '" + this._dtRacks.Rows[this._nActiveRack][Common.VbecsTables.Rack.RackGuid].ToString() + "'")[0].ItemArray;

						
					}
				}
			}
			catch (RowVersionException)
			{
				//CR2077?
				cbQCOffline.Enabled = false;
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
			


			if (CheckForFilledTemplate() == true &&	CheckForDailyUse() == true)
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip("Choose lot numbers and testing methods for all reagents in each rack");
			}
		}

	}

	/// <summary>
	/// Class DataGridColoredTextBoxColumn
	/// </summary>
	public class DataGridColoredTextBoxColumn : DataGridTextBoxColumn 
	{ 
		/// <summary>
		/// Paint
		/// </summary>
		/// <param name="g"></param>
		/// <param name="bounds"></param>
		/// <param name="source"></param>
		/// <param name="rowNum"></param>
		/// <param name="backBrush"></param>
		/// <param name="foreBrush"></param>
		/// <param name="alignToRight"></param>
		protected override void Paint(System.Drawing.Graphics g, 
			System.Drawing.Rectangle bounds, System.Windows.Forms.CurrencyManager 
			source, int rowNum, System.Drawing.Brush backBrush, System.Drawing.Brush 
			foreBrush, bool alignToRight) 
		{ 
			try
			{
				if (this.HeaderText == "")
				{
					object o = this.GetColumnValueAtRow(source, rowNum); 
					if( o!= null) 
					{
						if ((string)o != "")
						{
							char c = ((string)o)[0]; 
							if( c == 'V') 
							{ 
								backBrush = new SolidBrush(Color.Lime);
								foreBrush = new SolidBrush(Color.Black); 
							} 
							else if (c == 'W')
							{
								backBrush = new SolidBrush(Color.Yellow);
								foreBrush = new SolidBrush(Color.Black); 
							}
							else if (c == 'E')
							{
								backBrush = new SolidBrush(Color.Red);
								foreBrush = new SolidBrush(Color.Black); 
							}
							else
							{
								backBrush = new SolidBrush(Color.White);
								foreBrush = new SolidBrush(Color.Black); 
							}
						}
						else
						{
							backBrush = new SolidBrush(Color.White);
							foreBrush = new SolidBrush(Color.Black); 
						}
					} 
					else
					{
						backBrush = new SolidBrush(Color.White);
						foreBrush = new SolidBrush(Color.Black); 
					}
				}
			} 
			catch{}
			finally
			{ 
				base.Paint(g, bounds, source, rowNum, backBrush, foreBrush, alignToRight); 
			} 
 
		} 

	} 
}